<?php

namespace App\models;

use Illuminate\Database\Eloquent\Model;

class JobOrder extends Model 
{

    protected $table = 'job_orders';
    public $timestamps = true;
    protected $fillable = array('user_id', 'employee_id', 'vendor_id', 'location_id', 'added_by', 'piroirty_id', 'building_id', 'damage_id', 'customer_remark', 'technical_remark', 'type_id', 'category_id', 'detected_date', 'detected_time', 'date_completed', 'date_end_from_employee', 'text');

    public function location()
    {
        return $this->belongsTo('App\models\Location');
    }

    public function products()
    {
        return $this->hasMany('App\models\JobOrderProduct');
    }

    public function files()
    {
        return $this->hasMany('App\models\JobOrderFile');
    }

    public function piroirty()
    {
        return $this->hasOne('App\models\Piroirty');
    }

    public function type()
    {
        return $this->hasOne('App\models\Type');
    }

}